%\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{cdm}[2024/05/01 CDM LaTeX class]
\LoadClass[11pt,twoside]{article}
%\RequirePackage[margin=1.25in]{geometry}

\RequirePackage{authblk}
\RequirePackage{graphicx}
\RequirePackage{blindtext}
\RequirePackage{xcolor}
\RequirePackage{hyperref}
\RequirePackage{amsmath,amssymb,amsthm}
\RequirePackage{lastpage}
\RequirePackage{pageslts}
\RequirePackage{float}
\RequirePackage{tikz}


\textwidth=6in
\textheight=9in
\headheight.2cm
\topmargin-0.5in
\evensidemargin0.25in
\oddsidemargin0.25in
\def\baselinestretch{1.25}\large\normalsize

\hbadness3000
\vbadness30000
\parindent=0.3in
\parskip=3pt plus 1pt minus 1pt



\theoremstyle{plain}
\newtheorem{theorem}{Theorem}[section]
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{algorithm}[theorem]{Algorithm}
\theoremstyle{definition}
\newtheorem{definition}[theorem]{Definition}
\newtheorem{example}[theorem]{Example}
\newtheorem{remark}[theorem]{Remark}

\numberwithin{equation}{section}

\newcommand{\T}{\mathbb{T}}
\newcommand{\R}{\mathbb{R}}
\newcommand{\Q}{\mathbb{Q}}
\newcommand{\N}{\mathbb{N}}
\newcommand{\Z}{\mathbb{Z}}
\newcommand{\tx}[1]{\quad\mbox{#1}\quad}
\RequirePackage{fancyhdr}
\renewcommand{\headrulewidth}{0.7pt}
\fancypagestyle{firstpage}{%
\fancyhf{}
\lhead{
 \begin{minipage}{1.5cm}
 \centering
 \includegraphics[scale=0.8]{logo.png}
 \vspace{-0.5cm}
 \end{minipage}%
 \begin{minipage}{16cm}
 The Nepali Mathematical Sciences Report\\
 Regd No.: 53/033-034, ISSN: 2392--411X\\ \href{http://www.journal.cdmathtu.edu.np/about-the-journal.html}{http://www.journal.cdmathtu.edu.np}
 \vspace{-0.5cm}
 \end{minipage}
 }
 \rhead{
 Year: \pyear, Volume: \volume, No. \no\\
Pages: \strtpg--\lastpg\\
\href{https://\doi}{\doi}\\
\colorbox{black}{\color{white}\textbf{\arttype}}
 \vspace{-0.7cm}
}
  \renewcommand{\footrulewidth}{0.5pt}
  \lfoot{*Corresponding author}
  \rfoot{\copyright 2024 Central Department of Mathematics. All rights reserved.}
}

\pagestyle{fancy}
\pagenumbering{arabic}


\fancyhead[LE]{The Nepali Math. Sc. Report}
\fancyhead[RE]{Year: \pyear, Volume: \volume, No: \no}


\date{}






